function [ ] = pltspl( d,delta,n,c )
%Graph the S^r_d(delta) univariate spline with coeffs c over delta
%   Inputs are as in sval2

k = size(delta,2); %number of padded partition points
a = delta(1,1);
b = delta(1,k);

step = max( [(b-a)/1000, .001] );
t = a:step:b;
value = sval2(d,delta,n,c,t);
plot(t,value);


end

